float4x4 matView;
float4x4 matProjection;
float4x4 matViewProjection;
float4x4 matWorld;
float4x4 matWorldView;
float4x4 matWorldViewProjection;
float4x4 matMirror;

float time; 
float const0;
float const1;

float3 CameraPosition;
float3 CameraTarget;

bool    usealpha;
texture tex0;
texture tex1;
texture tex2;

sampler sTex0 = sampler_state
{
	texture = (tex0);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex1 = sampler_state
{
	texture = (tex1);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

sampler sTex2 = sampler_state
{
	texture = (tex2);
	MipFilter = Linear;
	MagFilter = Linear;
	MinFilter = Linear;
	
	AddressU = WRAP;
	AddressV = WRAP;
};

struct VS_INPUTdb
{
	float4 pos : POSITION;
	float3 norm : NORMAL;
	float2 tex0 : TEXCOORD0;
};

struct VS_OUTPUTdb
{
	float4 pos : POSITION;
	float2 tex0 : TEXCOORD0;
};

struct VS_OUTPUTdb2
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
	float2 tex0 : TEXCOORD0;
	float2 tex1 : TEXCOORD1;
};

VS_OUTPUTdb db01VS(VS_INPUTdb i)
{
	VS_OUTPUTdb o;
	o.pos = mul(matProjection, i.pos);
	o.tex0 = i.tex0;
	return o;
};

//Rednex dance
VS_OUTPUTdb db03VS(VS_INPUTdb i)
{
	VS_OUTPUTdb o;
	o.pos = mul(matProjection, i.pos);
	o.tex0.y = i.tex0.y;
	o.tex0.x = i.tex0.x + ((.001f*(i.pos.y+256))*sin((i.tex0.y*4)+const0));
	return o;
};

VS_OUTPUTdb db02VS(VS_INPUTdb i)
{
	VS_OUTPUTdb o;
	o.tex0 = i.tex0*20.f;
	o.tex0.x += time;
	o.pos = mul(i.pos, matWorldViewProjection);
	return o;	
};

///////////////////////////////////////////////////////////////////////

struct PS_INPUTdb
{
	float2 tex0 : TEXCOORD0;
	float4 diffuse : COLOR0;
};

float4 db01PS(PS_INPUTdb i) : COLOR0
{
	if(usealpha)
	{
		float4 color = tex2D(sTex0, i.tex0);
		color.a = clamp(1.15f-(1.f*color.rgb), 0, 1);
		color.rgb *= const0;
		return color;
	} else {
		float4 color = tex2D(sTex0, i.tex0)*const0;
		color.a = 1.f;
		return color;
	}
}

float4 db02PS(PS_INPUTdb i) : COLOR0
{
	return tex2D(sTex0, i.tex0);
}

///////////////////////////////////////////////////////////////////////

technique db01
{
	pass p0
	{
		VertexShader = compile vs_2_0 db01VS();
		PixelShader  = compile ps_2_0 db01PS();
	}
}


technique Dancer
{
	pass p0
	{
		VertexShader = compile vs_2_0 db03VS();
		PixelShader  = compile ps_2_0 db02PS();
	}
}

technique DanceFloor
{
	pass p0
	{
		VertexShader = compile vs_2_0 db02VS();
		PixelShader  = compile ps_2_0 db02PS();
	}
}
